<?php get_header(); ?>


<?php $menu_extra_sites = get_field('menu_extra_sites','option'); ?>
<div class="container">
	<?php
	if ($post->post_parent) {
		$query_id = wp_get_post_parent_id(get_the_ID());
	} else {
		$query_id = get_the_ID();
	}
	$terms = get_the_terms( $query_id, 'building_category');
	$term = array_pop($terms);

	// $terms = get_the_terms( get_the_ID(), 'building_category');
	// $term = array_pop($terms);

	$cat_banner = get_field('main_banner',$term);
	$cat_logo = get_field('main_logo',$term); ?>

	<?php if ($cat_banner) { ?>
		<img src="<?php echo $cat_banner['url']; ?>" class="main-banner wow fadeIn">
	<?php } ?>

	<?php if ( function_exists('yoast_breadcrumb')) {
		yoast_breadcrumb('
			<div class="breadcrumbs-box wow fadeInRight"><p id="breadcrumbs">','</p></div>
		');
	} ?>

	<div class="row title-box">
		<?php if ($cat_logo) { ?>
			<div class="col-sm-6 col-sm-push-18 text-right">
				<div class="title-box__container">
					<img src="<?php echo $cat_logo['url']; ?>" class="investment-logo wow fadeIn" data-wow-delay="400ms">
				</div>
			</div>
			<div class="col-sm-18 col-sm-pull-6">
		<?php } else { ?>
			<div class="col-sm-24">
		<?php } ?>
				<div class="title-box__container">
					<h1 class="h2 wow fadeIn"><?php echo get_the_title($query_id); ?></h1>
					<?php if (get_field('address',$term)) { ?>
						<p class="address wow fadeInRight" data-wow-delay="200ms"><?php the_field('address',$term); ?></p>
					<?php } ?>
				</div>
			</div>
	</div>
</div>


	<?php $post_id = get_the_ID();
	$parent = new WP_Query(
		array(
			'post_type' => 'buildings',
			'post_parent' => $query_id,
			'orderby' => 'menu_order',
			'order' => 'ASC',
			'post_status' => 'publish',
			'posts_per_page' => -1,
			'depth'	=> '1'
		)
	);
	wp_reset_postdata();
	if ( get_field('menu_extra_sites','option') or $parent->have_posts() ) { ?>
		<div class="investment_menu__box">
			<div class="investment_menu__container sticky_element">
				<div class="container">
					<div class="investment_menu wow fadeIn" data-wow-delay="200ms">
						<a href="<?php echo get_post_permalink($query_id); ?>" class="investment_menu__link<?php if (!$post->post_parent) echo ' active'; ?>">Opis</a>
						<?php if ( $parent->have_posts() ) {
							while ( $parent->have_posts() ) { $parent->the_post(); ?>
								<a href="<?php the_permalink(); ?>" class="investment_menu__link<?php if (get_the_ID() == $post_id) echo ' active'; ?>"><?php the_title(); ?></a>
							<?php } 
						} ?>						
						<?php foreach( $menu_extra_sites as $post) { // variable must be called $post (IMPORTANT)
							setup_postdata($post); ?>
							<a href="<?php the_permalink(); ?>" class="investment_menu__link" target="_blank">
								<?php if (get_field('site_title')) the_field('site_title'); else the_title(); ?>
							</a>	
							<?php wp_reset_postdata();
						} ?>
					</div>
				</div>
			</div>
		</div>
	<?php }
	wp_reset_query(); ?>


<div class="container">
	<?php $investment_content = get_field('investment_content'); ?>

	<?php if ($investment_content == 'desc') { ?>
		<!-- INVESTMENT - description -->
		<?php if (get_field('desc_title')) { ?>
			<h2 class="main-header text-center wow fadeIn"><?php the_field('desc_title'); ?></h2>
		<?php } elseif (get_field('desc_title','option')) { ?>
			<h2 class="main-header text-center wow fadeIn"><?php the_field('desc_title','option'); ?></h2>
		<?php } ?>
		<?php
		if (get_field('desc_text') or get_field('desc_extra')) { ?>
			<div class="row">
				<div class="col-sm-<?php if (get_field('desc_text') and get_field('desc_extra')) echo '14'; elseif (get_field('desc_text')) echo '24'; ?> wow fadeIn" data-wow-delay="200ms">
					<?php the_field('desc_text'); ?>
				</div>
				
				<div class="col-sm-<?php if (get_field('desc_text') and get_field('desc_extra')) echo '10'; elseif (!get_field('desc_text') and get_field('desc_extra')) echo '24'; ?> desc-photos">
					<?php $desc_photo_1 = get_field('desc_photo_1');
					$desc_photo_2 = get_field('desc_photo_2'); ?>
						
					<?php if (get_field('desc_extra') == 'photos' and have_rows('desc_photos')) { ?>
						<!--<div class="desc-photos hidden">
							<?php $d = 1;$dp = 0;$del = 200;
							while( have_rows('desc_photos') ) { the_row();
								$desc_photo = get_sub_field('photo');
								if ($desc_photo) ?>
									<a href="<?php echo $desc_photo['url']; ?>" rel="lightbox" style="top:<?php echo $dp; ?>px;" class="wow fadeIn" data-wow-delay="<?php echo $del; ?>ms">
										<img src="<?php echo $desc_photo['sizes']['large']; ?>">
									</a>
								<?php $dp = $dp + 80;$del = $del + 150;
								$d++;
							} ?>
						</div>-->						
						
						<div class="desc-photos owl-carousel owl-one-loop visible-xs-block marginbottom">
							<?php if ($desc_photo_1) { ?>
								<a href="<?php echo $desc_photo_1['url']; ?>" rel="lightbox" class="wow fadeIn" data-wow-delay="100ms">
									<div class="thumbnail-cover thumbnail-200" style="background-image: url(<?php echo $desc_photo_1['sizes']['large']; ?>);"></div>
								</a>
							<?php } ?>
							<?php if ($desc_photo_2) { ?>
								<a href="<?php echo $desc_photo_2['url']; ?>" rel="lightbox" class="wow fadeIn" data-wow-delay="200ms" style="top:80px;">
									<div class="thumbnail-cover thumbnail-200" style="background-image: url(<?php echo $desc_photo_2['sizes']['large']; ?>);"></div>
								</a>
							<?php } ?>
						</div>
					<?php } ?>
					
					<?php if (get_field('desc_extra') == 'photos' and $desc_photo_1) { ?>
						<div class="desc-photos hidden-xs">
							<?php if ($desc_photo_1) { ?>
								<a href="<?php echo $desc_photo_1['url']; ?>" rel="lightbox" class="wow fadeIn" data-wow-delay="100ms">
									<div class="thumbnail-cover thumbnail-200" style="background-image: url(<?php echo $desc_photo_1['sizes']['large']; ?>);"></div>
								</a>
							<?php } ?>
							<?php if ($desc_photo_2) { ?>
								<a href="<?php echo $desc_photo_2['url']; ?>" rel="lightbox" class="wow fadeIn" data-wow-delay="200ms" style="top:80px;">
									<div class="thumbnail-cover thumbnail-200" style="background-image: url(<?php echo $desc_photo_2['sizes']['large']; ?>);"></div>
								</a>
							<?php } ?>
						</div>
					<?php } ?>
					
					<?php $desc_movie = get_field('desc_movie');
					if (get_field('desc_extra') == 'movie' and get_field('desc_movie')) { ?>
						<div class="videoWrapper">
							<iframe width="100%" height="300" src="https://www.youtube.com/embed/<?php the_field('desc_movie'); ?>?rel=0&amp;controls=1&amp;showinfo=0" frameborder="0" allowfullscreen></iframe>
						</div>
					<?php } ?>
				</div>
			</div>
		<?php } ?>
		
		<?php if (get_field('add_extra_links')) { ?>
			<div class="row">
				<div class="col-sm-24 links-box text-center">
					<?php $del = 10;
					foreach( $menu_extra_sites as $post) { // variable must be called $post (IMPORTANT)
						setup_postdata($post); ?>
						<a href="<?php the_permalink(); ?>" class="btn btn-primary investment_menu__link wow fadeIn" target="_blank" data-wow-delay="<?php echo $del; ?>ms"><?php the_title(); ?></a>	
						<?php $del = $del + 50;
						wp_reset_postdata();
					} ?>
				</div>
			</div>
		<?php } ?>

		<?php if( have_rows('desc_links') ) { ?>
			<div class="row">
				<div class="col-sm-24 links-box text-center">
					<?php $del = 10;
					while ( have_rows('desc_links') ) { the_row();
						$link_file = get_sub_field('link_file');
						$link_cat = get_sub_field('link_cat'); ?>
						<a href="<?php if (get_sub_field('link_source') == 'site' and get_sub_field('link_site')) the_sub_field('link_site'); elseif (get_sub_field('link_source') == 'url' and get_sub_field('link_url')) the_sub_field('link_url'); elseif (get_sub_field('link_source') == 'cat' and get_term_link($link_cat)) echo $link_file['url']; elseif (get_sub_field('link_source') == 'file' and $link_file) echo $link_file['url']; ?>" class="wow fadeIn <?php if (get_sub_field('link_type') == 'default') echo 'btn btn-default';  elseif (get_sub_field('link_type') == 'primary') echo 'btn btn-primary'; else echo 'normal-link'; ?>"<?php if (get_sub_field('link_source') == 'url' and (get_sub_field('link_url') or $link_file)) { ?> target="_blank"<?php } ?> data-wow-delay="<?php echo $del; ?>ms">
							<?php if (get_sub_field('link_content')) { ?>
								<?php the_sub_field('link_content') ?>
							<?php } else { ?>
								Czytaj więcej
							<?php } ?>
						</a>
					<?php $del = $del + 50;
					} ?>
				</div>
			</div>
		<?php } ?>

	<?php } elseif ($investment_content == 'vr') { ?>
		<!-- INVESTMENT - virtual reality -->
		<div id="vr">
			<?php if (get_field('vr_title')) { ?>
				<h2 class="main-header text-center wow fadeIn"><?php the_field('vr_title'); ?></h2>
			<?php } elseif (get_field('vr_title','option')) { ?>
				<h2 class="main-header text-center wow fadeIn"><?php the_field('vr_title','option'); ?></h2>
			<?php } ?>
			<?php the_field('vr_text'); ?>

			<?php if (get_field('vr_code')) the_field('vr_code'); ?>
		</div>

	<?php } elseif ($investment_content == '3d') { ?>
		<!-- INVESTMENT - 3d search -->
		<?php if( get_field('building_image') ): ?>
			<div class="row marginbottom clear">
				<div class="col-sm-24">
					<?php if( get_field('3d_title') ) { ?>
						<h2 class="main-header main-header wow fadeIn"><?php the_field('3d_title'); ?></h2>
					<?php } elseif (get_field('3d_title','option')) { ?>
						<h2 class="main-header text-center wow fadeIn"><?php the_field('3d_title','option'); ?></h2>
					<?php } ?>
				</div>
				<div class="col-sm-24 text-center">		

					<div class="apartments-box floor-box relative wow fadeIn">
						<?php if (get_field('map_title')) { ?>
							<div class="apartments__legend text-left">
								<h4><?php the_field('map_title'); ?></h4>
							</div>
						<?php } ?>			
					
						<div id="apartments">
							<img id="apartments_background" src="<?php the_field('building_image'); ?>" />
							<div id="apartments_canvas_cont"></div>
						</div>
					</div>

					<?php
						if (get_field('apartments_available_color','option'))
							$color_free = get_field('apartments_available_color','option');
						else
							$color_free = '#66c500';
						if (get_field('apartments_booked_color','option'))
							$color_booked = get_field('apartments_booked_color','option');
						else
							$color_booked = '#e69200';
						if (get_field('apartments_sold_color','option'))
							$color_sold = get_field('apartments_sold_color','option');
						else
							$color_sold = '#e60500';
						$floor_link_not = get_field('floor_link');
						$apartments = get_field('apartments');
						if ($apartments) {
							foreach ($apartments as &$a) {
								if ($a['apartment_id']) {
									$a['status'] = get_field('status', $a['apartment_id']);
									$a['size'] = get_field('size', $a['apartment_id']);
									$a['link'] = get_post_permalink($a['apartment_id']);
								}
								if ($a['floor_id']) {
									$a['floor_link'] = esc_url(get_term_link($a['floor_id']));
								}
							}
							unset($a);
						}
						?>
						<script>
							var color_free = <?php echo wp_json_encode($color_free); ?>;
							var color_booked = <?php echo wp_json_encode($color_booked); ?>;
							var color_sold = <?php echo wp_json_encode($color_sold); ?>;
							var floor_link_not = <?php echo wp_json_encode($floor_link_not); ?>;
							var apartments = <?php echo wp_json_encode($apartments); ?>;
							var apartment = jQuery("#apartments");
							var backgroundImg = jQuery("#apartments_background");
							var konvaContainer = jQuery("#apartments_canvas_cont");
							var width = 0;
							var height = 0;
							var scale = 1;

							var updateTooltip = function(tooltip, x, y, text) {
							tooltip.getText().setText(text);
							tooltip.setPosition({
								x : x,
								y : y
							});
							tooltip.show();
						}

						var calcSizes = function() {
							scale = apartment.width() / backgroundImg[0].naturalWidth;
							width = apartment.width();
							height = backgroundImg[0].naturalHeight * scale;
							apartment.height(height);
							backgroundImg.width(width);
							backgroundImg.height(height);
						}

						var setupStage = function() {
							var stage = new Konva.Stage({
								container: 'apartments_canvas_cont',
								width: width,
								height: height
							});

							var tooltipLayer = new Konva.Layer();
							var tooltip = new Konva.Label({
								opacity: 0.75,
								visible: false,
								listening: false
							});

							tooltip.add(new Konva.Tag({
								fill: 'black',
								pointerDirection: 'down',
								pointerWidth: 10,
								pointerHeight: 10,
								lineJoin: 'round',
								shadowColor: 'black',
								shadowBlur: 10,
								shadowOffset: 10,
								shadowOpacity: 0.5
							}));

							tooltip.add(new Konva.Text({
								text: '',
								fontFamily: 'Lato',
								fontSize: 18,
								padding: 5,
								fill: 'white'
							}));

							tooltipLayer.add(tooltip);

							var shapesLayer = new Konva.Layer({
								scale: {x: scale, y: scale}
							});
							// event handlers
							var floorMouseOver = function(evt) {
								var shape = evt.target;
								if (shape) {
									shape.setOpacity(0.6);
									shapesLayer.draw();
									document.body.style.cursor = 'pointer';
								}
							}
							var floorMouseMove = function(evt) {
								var shape = evt.target;
								if (shape) {
									var mousePos = stage.getPointerPosition();
									var x = (mousePos.x);
									var y = (mousePos.y - 5);
									updateTooltip(tooltip, x, y, shape.attrs.key);
									tooltipLayer.batchDraw();
								}
							}
							var floorClick = function(evt) {
								var shape = evt.target;
								if (shape && shape.attrs.link)
									location.href = shape.attrs.link;
							}
							// draw areas
							if (apartments) {
								for (var i = 0; i < apartments.length; ++i) {
									var status = apartments[i].status;
									var size = apartments[i].size;
									if (apartments[i].floor_id) {
										var shape = new Konva.Line({
											points: JSON.parse(apartments[i].points),
											opacity: 0.1,
											fill: color_sold,
											closed : true,
											// custom attr
											key: apartments[i].apartment,
											link: apartments[i].floor_link

										});
										var floorMouseOut =  function(evt) {
											var shape = evt.target;
											if (shape) {
												shape.setOpacity(0.1);
												shapesLayer.draw();
												tooltip.hide();
												tooltipLayer.draw();
												document.body.style.cursor = 'default';
											}
										}
									} else {
										if (status == 'free') {
											var shape = new Konva.Line({
												points: JSON.parse(apartments[i].points),
												opacity: 0.4,
												fill: color_free,
												closed : true,
												// custom attr
												key: apartments[i].apartment + ' - ' + size + ' mkw',
												link: apartments[i].link

											});
											var floorMouseOut =  function(evt) {
												var shape = evt.target;
												if (shape) {
													shape.setOpacity(0.4);
													shapesLayer.draw();
													tooltip.hide();
													tooltipLayer.draw();
													document.body.style.cursor = 'default';
												}
											}
										} else if (status == 'booked') {
											var shape = new Konva.Line({
												points: JSON.parse(apartments[i].points),
												opacity: 0.4,
												fill: color_booked,
												closed : true,
												// custom attr
												key: apartments[i].apartment + ' - zarezerwowane',
												link: apartments[i].link
											});
											var floorMouseOut =  function(evt) {
												var shape = evt.target;
												if (shape) {
													shape.setOpacity(0.4);
													shapesLayer.draw();
													tooltip.hide();
													tooltipLayer.draw();
													document.body.style.cursor = 'default';
												}
											}
										} else if (status == 'sold') {
											var shape = new Konva.Line({
												points: JSON.parse(apartments[i].points),
												opacity: 0.4,
												fill: color_sold,
												closed : true,
												// custom attr
												key: apartments[i].apartment + ' - sprzedane',
												link: apartments[i].link

											});
											var floorMouseOut =  function(evt) {
												var shape = evt.target;
												if (shape) {
													shape.setOpacity(0.4);
													shapesLayer.draw();
													tooltip.hide();
													tooltipLayer.draw();
													document.body.style.cursor = 'default';
												}
											}
										} else {
											var shape = new Konva.Line({
												points: JSON.parse(apartments[i].points),
												opacity: 0.1,
												fill: color_sold,
												closed : true,
												// custom attr
												key: apartments[i].apartment,
												link: apartments[i].link

											});
											var floorMouseOut =  function(evt) {
												var shape = evt.target;
												if (shape) {
													shape.setOpacity(0.1);
													shapesLayer.draw();
													tooltip.hide();
													tooltipLayer.draw();
													document.body.style.cursor = 'default';
												}
											}
										}
									}

									shape.on('mouseover', floorMouseOver);
									shape.on('mouseout', floorMouseOut);
									shape.on('mousemove', floorMouseMove);
									shape.on('click tap', floorClick);

									shapesLayer.add(shape);
								}
							}


							var lastTouchedShape = null;
							stage.on('touchmove', function(evt) {
								var shape = evt.target;
								if (shape) {
									if (lastTouchedShape != shape && lastTouchedShape != null) {
										lastTouchedShape.setOpacity(0);
									}
									lastTouchedShape = shape;
									shape.setOpacity(0.6);
									shapesLayer.draw();

									var mousePos = stage.getPointerPosition();
									var x = (mousePos.x);
									var y = (mousePos.y - 20);
									updateTooltip(tooltip, x, y, shape.attrs.key);
									tooltipLayer.batchDraw();
								} else if (lastTouchedShape) {
									lastTouchedShape.setOpacity(0);
									lastTouchedShape.draw();
									tooltip.hide();
									tooltipLayer.draw();
									lastTouchedShape = null;
								}
							});

							stage.on('touchend', function(evt) {
								if (lastTouchedShape) {
									lastTouchedShape.setOpacity(0);
									lastTouchedShape.draw();
									tooltip.hide();
									tooltipLayer.draw();
									lastTouchedShape = null;
								}
							});

							stage.add(shapesLayer);
							stage.add(tooltipLayer);

							jQuery(window).resize(function(event) {
								calcSizes();
								stage.width(width);
								stage.height(height);
								shapesLayer.scale({x: scale, y: scale});
							});
						}

						var positionsInitialized = false;
						backgroundImg.load(function() {
							if (!positionsInitialized) {
								calcSizes();

								var positionCss = {
									position: "absolute",
									top: 0,
									left: 0
								};
								backgroundImg.css(positionCss);
								konvaContainer.css(positionCss);

								setupStage();

								positionsInitialized = true;
							}
						});
						if (backgroundImg[0].complete)
							backgroundImg.load();
						</script>

				</div>
			</div>
		<?php endif; ?>

	<?php } elseif ($investment_content == 'gallery') { ?>
		<!-- INVESTMENT - gallery -->
		<?php if( get_field('gallery_title') ) { ?>
			<h2 class="main-header main-header text-center wow fadeIn"><?php the_field('gallery_title'); ?></h2>
		<?php } elseif (get_field('gallery_title','option')) { ?>
			<h2 class="main-header text-center wow fadeIn"><?php the_field('gallery_title','option'); ?></h2>
		<?php } ?>
		<?php if( (have_rows('gallery')) ) { ?>
			<div class="gallery-box row marginbottom">
				<div class="col-sm-24">
					<div class="filters marginbottom clear">
						<?php $ga = 0;$del = 100;
						while ( (have_rows('gallery')) ) : the_row(); ?>
							<?php if (get_sub_field('gallery_name')) { ?>
								<a class="button<?php if ($ga == 0) echo ' selected'; ?> wow fadeIn" data-wow-delay="<?php echo $del; ?>ms" data-filter=".<?php echo 'category-'.$ga; ?>"><?php the_sub_field('gallery_name'); ?></a>
							<?php } ?>
						<?php $ga++;$del = $del + 150;
						endwhile; ?>
					</div>
					<div class="gallery isotope-grid wow fadeIn">
						<div class="grid-sizer"></div>
						<div class="gutter-sizer"></div>
						<?php $g = 0;
						while ( (have_rows('gallery')) ) : the_row(); ?>
							<?php $gallery_images = get_sub_field('gallery_images'); ?>
							<?php if ($gallery_images) {
								foreach( $gallery_images as $imagegal ) { ?>
									<?php if( $imagegal['description'] ) { ?>
										<div class="grid-item<?php echo ' category-'.$g; ?>">
											<a href="" data-toggle="modal" data-target="#video-<?php echo $imagegal['ID']; ?>" class="gallery-img hover-link hover-video" title="<?php echo $imagegal['caption']; ?>">
												<div class="border"></div>
												<div class="thumbnail-200 thumbnail-cover" style="background-image:url(<?php echo $imagegal['url']; ?>)">
													<?php if( $imagegal['caption'] ) { ?>
														<p class="caption"><?php echo $imagegal['caption']; ?></p>
													<?php } ?>
												</div>
											</a>								
											
										</div>
									<?php } else { ?>
										<div class="grid-item<?php echo ' category-'.$g; ?>">
											<a href="<?php echo $imagegal['url']; ?>" rel="lightbox" class="gallery-img hover-link" title="<?php echo $imagegal['caption']; ?>">
												<div class="border"></div>
												<div class="thumbnail-200 thumbnail-cover" style="background-image: url(<?php echo $imagegal['sizes']['large']; ?>);"></div>
											</a>
										</div>
									<?php }
								}
							}
							$g++; ?>
						<?php endwhile; ?>
					</div>
					<?php $g = 0;
					while ( (have_rows('gallery')) ) : the_row(); ?>
						<?php $gallery_images = get_sub_field('gallery_images'); ?>
						<?php if ($gallery_images) {
							foreach( $gallery_images as $imagegal ) { ?>
								<?php if( $imagegal['description'] ) { ?>
									<div class="modal fade" id="video-<?php echo $imagegal['ID']; ?>" tabindex="-1" role="dialog" aria-labelledby="label-<?php echo $imagegal['ID']; ?>">
										<div class="modal-dialog modal-lg">
											<div class="modal-content">
												<div class="modal-header">
													<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
													<?php if( $imagegal['caption'] ) { ?>
														<h4 class="modal-title" id="label-<?php echo $imagegal['ID']; ?>"><?php echo $imagegal['caption']; ?></h4>
													<?php } ?>
												</div>
												<div class="modal-body">
													<iframe width="100%" height="450" src="https://www.youtube.com/embed/<?php echo $imagegal['description']; ?>" frameborder="0" allowfullscreen></iframe>
												</div>
											</div>
										</div>
									</div>
								<?php }
							}
						}
						$g++; ?>
					<?php endwhile; ?>
				</div>
			</div>
		<?php } ?>

	<?php } elseif ($investment_content == 'flats') { ?>
		<!-- INVESTMENT - flats -->
		<div class="flats marginbottom clear">
			<?php if (get_field('flats_title')) { ?>
				<h2 class="main-header text-center wow fadeIn"><?php the_field('flats_title'); ?></h2>
			<?php } elseif (get_field('flats_title','option')) { ?>
				<h2 class="main-header text-center wow fadeIn"><?php the_field('flats_title','option'); ?></h2>
			<?php } ?>
			
			<?php if (get_field('content')) { ?>
				<div class="marginbottom wow fadeIn">
					<?php the_field('content'); ?>
				</div>
			<?php } ?>

			<?php if (get_field('apartment_search')) { ?>
				
				<div class="marginbottom">
					<?php if (get_field('show_list_table')) { ?>
						<a class="btn btn-default btn-mini btn-apartments-list wow fadeIn"><i class="fa fa-list" aria-hidden="true"></i> Lista mieszkań</a>
						<a class="btn btn-default btn-mini btn-apartments-table wow fadeIn" data-wow-delay="150ms"><i class="fa fa-table" aria-hidden="true"></i> Tabela mieszkań</a>
					<?php } ?>
				</div>
				
				<?php add_filter( 'sf-after-form', 'afterResults' );
				function afterResults(){ ?>
					<div class="sticky_element result-header-box">
						<div id="resultsHeader" class="row hidden-xs hidden-sm">
							<div class="col-sm-24 sf-results-header">
								<div class="col-sm-7">
									Inwestycja / mieszkanie
								</div>
								<div class="col-sm-2">
									Piętro
								</div>
								<div class="col-sm-2">
									Pokoje
								</div>
								<div class="col-sm-2">
									Metraż
								</div>
								<div class="col-sm-2">
									Balkon
								</div>
								<div class="col-sm-2">
									Taras
								</div>
								<div class="col-sm-3">
									Antresola
								</div>
								<div class="col-sm-4">
									Status / cena
								</div>
							</div>
						</div>
					</div>
				<?php } ?>
			
				<div class="marginbottom">
					<?php the_field('apartment_search'); ?>
				</div>
			<?php } ?>
			
			<?php if (get_field('show_list')) {
				$invest_title = get_the_title($query_id);
				$apartments = new WP_Query(
					array(
						'post_type' => 'apartments',
						'meta_key' => 'status',
						'orderby' => 'meta_value_num',
						'order' => 'ASC',
						'post_status' => 'publish',
						'posts_per_page' => -1,
						'tax_query' => array(
							array (
								'taxonomy' => 'apartment_category',
								'field' => 'slug',
								'terms' => $term,
							)
						)
					)
				);
				wp_reset_postdata();
				if ( $apartments->have_posts() ) { ?>
					<!--<div class="apartment-item <?php if (get_field('status') == '0_promo' or get_field('status') == '1_free') echo 'free'; elseif (get_field('status') == '2_booked') echo 'booked'; elseif (get_field('status') == '3_sold') echo 'sold'; ?>">
						<?php if (get_field('status') == '0_promo' or get_field('status') == '1_free') { ?><a href="<?php the_permalink(); ?>" class="link-absolute" target="_blank"></a><?php } ?>	
						<div class="row">
							<div class="col-sm-4">
								<?php $model_3d = get_field('model_3d');
								$photo = get_field('photo');
								if ($photo) { ?>
									<img src="<?php echo $photo['sizes']['large']; ?>">
								<?php } elseif ($model_3d) { ?>
									<img src="<?php echo $model_3d['sizes']['large']; ?>">
								<?php } ?>
							</div>
							<div class="col-sm-16">
								<h3><?php echo $invest_title; ?> <span>Mieszkanie <?php the_title(); ?></span></h3>
								<div class="row display-flex">
									<div class="col-sm-17 display-flex-middle">
										<?php $status_field = get_field_object('status');
										$value = $status_field['value'];
										$status = $status_field['choices'][ $value ];
										if (get_field('status')) { ?>
											<p class="status <?php the_field('status'); ?>"><?php if (get_field('status') == '0_promo') echo $status_field['choices'][ '1_free' ]; else echo $status; ?></p>
										<?php } ?>					
									</div>					
									<div class="col-sm-7 display-flex-middle">
										<?php if (get_field('promotion')) { ?>
											<p class="promotion promotion-#meta_promotion# #meta_promotion_type#">% promocja</p>
										<?php } ?>									
									</div>
								</div>
								<div class="row display-flex">
									<div class="col-sm-18 display-flex-middle">
										<p class="apartment-details">						
											<?php if (get_field('size')) { ?>Metraż: <strong><?php the_field('size'); ?> m<sup>2</sup></strong>  <?php } ?>
											<?php if (get_field('rooms')) { ?>Liczba pokoi: <strong><?php the_field('rooms'); ?></strong>  <?php } ?>
											<?php if (get_field('floor') or get_field('floor') == '0') { ?>Piętro: <strong><?php if (get_field('floor') == '0') { echo '0'; } else { ?><?php the_field('floor'); ?><?php } ?></strong>  <?php } ?>
											<?php if (get_field('show_balcony') and get_field('balcony')) { ?>Balkon: <strong><?php the_field('balcony'); ?> m<sup>2</sup></strong>  <?php } ?>
											<?php if (get_field('show_terrace') and get_field('terrace')) { ?>Taras: <strong><?php the_field('terrace'); ?> m<sup>2</sup></strong>  <?php } ?>
										</p>
									</div>					
									<div class="col-sm-7 display-flex-middle">					
										<?php $price_all = get_field('price_all');
										if (get_field('show_price') and $price_all) {
											$price = number_format( $price_all, 0, ',', ' '); ?>
											<p class="price"><span class="visible-xs-inline-block visible-sm-inline-block">Cena:  </span><?php echo $price; ?> zł</p>
										<?php } else { ?>
											<?php if (get_field('status') == '0_promo' or get_field('status') == '1_free') { ?><a href="" class="btn btn-default">Zapytaj o cenę</a><?php } ?>
										<?php } ?>
									</div>
								</div>
							</div>
							<div class="col-sm-3 text-right">
								<?php if (has_post_thumbnail()) {
									$thumb_id = get_post_thumbnail_id(get_the_ID()); ?>
									<img src="<?php echo wp_get_attachment_url($thumb_id); ?>">
								<?php } ?>
							</div>
						</div>
					</div> -->
					
					<div class="apartment-list">
						<?php while ( $apartments->have_posts() ) { $apartments->the_post(); ?>
							<div class="apartment-item <?php if (get_field('status') == '0_promo' or get_field('status') == '1_free') echo 'free'; elseif (get_field('status') == '2_booked') echo 'booked'; elseif (get_field('status') == '3_sold') echo 'sold'; ?>">
								<?php if (get_field('status') == '0_promo' or get_field('status') == '1_free') { ?><a href="<?php the_permalink(); ?>" class="link-absolute" target="_blank"></a><?php } ?>	
								<div class="row">
									<div class="col-sm-4">
										<?php $model_3d = get_field('model_3d');
										$photo = get_field('photo');
										$images = get_field('gallery');
										$image  = $images[0];
										if ($photo) { ?>
											<img src="<?php echo $photo['sizes']['medium']; ?>">
										<?php } elseif ($model_3d) { ?>
											<img src="<?php echo $model_3d['sizes']['medium']; ?>">
										<?php } elseif ($image) { ?>
											<img src="<?php echo $image['sizes']['medium']; ?>">
										<?php } ?>
									</div>
									<div class="col-sm-16">
										<h3><?php echo $invest_title; ?> <span>Mieszkanie <?php the_title(); ?></span></h3>
										<div class="row display-flex">
											<div class="col-sm-17 display-flex-middle">
												<?php $status_field = get_field_object('status');
												$value = $status_field['value'];
												$status = $status_field['choices'][ $value ];
												if (get_field('status')) { ?>
													<p class="status <?php the_field('status'); ?>"><?php if (get_field('status') == '0_promo') echo $status_field['choices'][ '1_free' ]; else echo $status; ?></p>
												<?php } ?>
											</div>
											<div class="col-sm-7 display-flex-middle">
												<?php $price_all = get_field('promotion');
												if (get_field('promotion')) { ?>
													<p class="promotion promotion-<?php the_field('promotion'); ?> <?php the_field('promotion_type'); ?>">% promocja</p>
												<?php } ?>
											</div>
										</div>
										<div class="row display-flex">
											<div class="col-sm-17 display-flex-middle">
												<p class="apartment-details">
													<?php if (get_field('size')) { ?>Metraż: <strong><?php the_field('size'); ?> m<sup>2</sup></strong>  <?php } ?>
													<?php if (get_field('rooms')) { ?>Ilość pokoi: <strong><?php the_field('rooms'); ?></strong>  <?php } ?>
													<?php if (get_field('floor')) { ?>Piętro: <strong><?php the_field('floor'); ?></strong>  <?php } ?>
													<?php if (get_field('show_balcony') and get_field('balcony')) { ?>Balkon: <strong><?php the_field('balcony'); ?> m<sup>2</sup></strong>  <?php } ?>
													<?php if (get_field('show_terrace') and get_field('terrace')) { ?>Taras: <strong><?php the_field('terrace'); ?> m<sup>2</sup></strong>  <?php } ?>
												</p>
											</div>
											<div class="col-sm-7 display-flex-middle">
												<?php $price_all = get_field('price_all');
												if (get_field('show_price') and $price_all) {
													$price = number_format( $price_all, 0, ',', ' '); ?>
													<p class="price"><span class="visible-xs-inline-block visible-sm-inline-block">Cena:  </span><?php echo $price; ?> zł</p>
												<?php } elseif (get_field('status') == 'free') { ?>
													<a href="" class="btn btn-default">Zapytaj o cenę</a>
												<?php } ?>
											</div>
										</div>
									</div>
									<div class="col-sm-4 text-right">
										<?php if (has_post_thumbnail()) {
											$thumb_id = get_post_thumbnail_id($post->ID); ?>
											<img src="<?php echo wp_get_attachment_url($thumb_id); ?>">
										<?php } ?>
									</div>
								</div>
							</div>
						<?php } ?>
					</div>					
				<?php }
				wp_reset_query();
			} ?>
		</div>

	<?php } elseif ($investment_content == 'location') { ?>
		<!-- INVESTMENT - location -->
		<div class="location marginbottom clear">
			<?php if (get_field('location_title')) { ?>
				<h2 class="main-header text-center wow fadeIn"><?php the_field('location_title'); ?></h2>
			<?php } elseif (get_field('location_title','option')) { ?>
				<h2 class="main-header text-center wow fadeIn"><?php the_field('location_title','option'); ?></h2>
			<?php } ?>

			<div class="row">
				<?php if (get_field('map_code')) { ?>
					<div class="col-sm-24 map-code">
						<?php the_field('map_code'); ?>
					</div>
				<?php } ?>
				<?php if (get_field('location_text')) { ?>
					<div class="location-text col-sm-24 margintop marginbottom wow fadeIn">
						<?php the_field('location_text'); ?>
					</div>
				<?php } ?>
				<?php $location_gallery = get_field('location_gallery');

				if ($location_gallery) { ?>
					<div id="carousel-location" class="carousel carousel-fade slide col-sm-24 wow fadeIn" data-ride="carousel">
						<div class="carousel-inner" role="listbox">
							<?php $location_gallery_count = count($location_gallery);
							$i = 1; ?>
							<?php foreach ($location_gallery as $key => $image) { ?>
								<div class="item<?php if ($i == 1) echo ' active'; ?>">
									<p class="slider-counter text-center"><?php echo $i . ' / ' . $location_gallery_count; ?></p>

									<div class="row">
										<div class="col-sm-6 slider-nav hidden-xs transition">
											<a href="#carousel-location" data-slide="prev">
												<div class="thumbnail-200 thumbnail-cover" style="background-image:url(<?php if(isset($location_gallery[$key - 1])) echo $location_gallery[$key - 1]['url']; else echo $location_gallery[$location_gallery_count-1]['url']; ?>)"></div>
											</a>
										</div>

										<div class="col-sm-12">
											<?php if( $image['description'] ): ?>
												<a href="" data-toggle="modal" data-target="#loc-video-<?php echo $image['ID']; ?>">
													<div class="thumbnail-400 thumbnail-cover" style="background-image:url(<?php echo $image['url']; ?>)">
														<div class="gallery-video-zoom">
															<i class="fa fa-play-circle"></i>
														</div>
													</div>
												</a>
												<div class="modal fade" id="loc-video-<?php echo $image['ID']; ?>" tabindex="-1" role="dialog" aria-labelledby="label-<?php echo $image['ID']; ?>">
													<div class="modal-dialog modal-lg">
														<div class="modal-content">
															<div class="modal-header">
																<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
																<h4 class="modal-title" id="label-<?php echo $image['ID']; ?>"><?php echo $image['alt']; ?></h4>
															</div>
															<div class="modal-body">
																<iframe width="100%" height="450" src="<?php echo $image['description']; ?>" frameborder="0" allowfullscreen></iframe>
															</div>
														</div>
													</div>
												</div>
											<?php else : ?>
												<a href="<?php echo $image['url']; ?>" rel="lightbox" class="gallery-img hover-link" title="<?php echo $image['caption']; ?>">
													<div class="thumbnail-400 thumbnail-cover" style="background-image:url(<?php echo $image['url']; ?>)"></div>
												</a>
											<?php endif; ?>
										</div>

										<div class="col-sm-6 slider-nav hidden-xs transition">
											<a href="#carousel-location" data-slide="next">
												<div class="thumbnail-200 thumbnail-cover" style="background-image:url(<?php if(isset($location_gallery[$key + 1])) echo $location_gallery[$key + 1]['url']; else echo $location_gallery[0]['url']; ?>)"></div>
											</a>
										</div>
									</div>

									<div class="slider-controls text-center">
										<a class="slider-control-left" href="#carousel-location" role="button" data-slide="prev"></a>
										<a class="slider-control-right" href="#carousel-location" role="button" data-slide="next"></a>
									</div>
								</div>
								<?php $i++;
							} ?>
						</div>
					</div>
				<?php } ?>
			</div>
		</div>
		
	<?php } elseif ($investment_content == 'promo') { ?>
		<!-- INVESTMENT - promotion -->
		<div id="promo">
			<?php if (get_field('promo_title')) { ?>
				<h2 class="main-header text-center wow fadeIn"><?php the_field('promo_title'); ?></h2>
			<?php } elseif (get_field('promo_title','option')) { ?>
				<h2 class="main-header text-center wow fadeIn"><?php the_field('promo_title','option'); ?></h2>
			<?php } ?>
			
			<?php if (have_rows('promo_list') ) { ?>
				<div class="promotion-list grid grid-<?php if($promo_columns) echo $promo_columns; else echo '1'; ?>">
					<div class="grid-sizer"></div>
					<div class="gutter-sizer"></div>
					<?php $p = 0;
					while ( have_rows('promo_list') ) { the_row(); ?>						
						<div class="promo-item grid-item">
							<?php $promo_img = get_sub_field('promo_img');
							if ($promo_img) { ?>
								<div class="relative">
									<img src="<?php if ($promo_img) echo $promo_img['sizes']['large']; ?>">
									<?php if (get_sub_field('promo_link')) { ?><?php } ?>
								</div>
							<?php } ?>
							<?php if (get_sub_field('promo_title')) { ?>
								<h4><?php the_sub_field('promo_title'); ?></h4>
							<?php } ?>
							<?php the_sub_field('promo_text'); ?>
							<?php if (get_sub_field('promo_link')) { ?>
								<a href="<?php the_sub_field('promo_link'); ?>" class="btn btn-mini btn-default" target="_blank">Zobacz</a>
							<?php } ?>
						</div>
					<?php $p++;
					} ?>
				</div>
			<?php } ?>
			
			<?php $promo_columns = get_field('promo_columns');
			if (get_field('show_promo_apartments')) {
				$promo_query = new WP_Query(
					array(
						'post_type' => 'apartments',
						'orderby' => 'menu_order',
						'order' => 'ASC',
						'post_status' => 'publish',
						'posts_per_page' => -1,
						'tax_query' => array(
							array (
								'taxonomy' => 'apartment_category',
								'field' => 'slug',
								'terms' => $term,
							)
						),		
						'meta_query' => array(
							array(
								'key' => 'promotion',
								'value' => '1',
								'compare' => 'LIKE'
							)
						)
					)
				);
				wp_reset_postdata();
				if ( $promo_query->have_posts() ) { ?>
					<div class="apartment-list">
						<?php while ( $promo_query->have_posts() ) { $promo_query->the_post(); ?>
							<div class="apartment-item <?php the_field('status');?>">
								<?php if (get_field('status') != 'sold') { ?><a href="<?php the_permalink(); ?>" class="link-absolute" target="_blank"></a><?php } ?>
								<div class="row">
									<div class="col-sm-4">
										<?php if (has_post_thumbnail()) {
											$thumb_id = get_post_thumbnail_id($post->ID); ?>
											<img src="<?php echo wp_get_attachment_url($thumb_id); ?>">
										<?php } ?>
									</div>
									<div class="col-sm-16">
										<h3><span>Mieszkanie <?php the_title(); ?></span></h3>
										<div class="row display-flex">
											<div class="col-sm-17 display-flex-middle">
												<?php $status_field = get_field_object('status');
												$value = $status_field['value'];
												$status = $status_field['choices'][ $value ];
												if (get_field('status')) { ?>
													<p class="status <?php the_field('status'); ?>"><?php echo $status; ?></p>
												<?php } ?>
											</div>
											<div class="col-sm-7 display-flex-middle">
												<?php $price_all = get_field('promotion');
												if (get_field('promotion')) { ?>
													<p class="promotion promotion-<?php the_field('promotion'); ?> <?php the_field('promotion_type'); ?>">% promocja</p>
												<?php } ?>
											</div>
										</div>
										<div class="row display-flex">
											<div class="col-sm-18 display-flex-middle">
												<p class="apartment-details">
													<?php if (get_field('size')) { ?>Metraż: <strong><?php the_field('size'); ?> m<sup>2</sup></strong>  <?php } ?>
													<?php if (get_field('rooms')) { ?>Ilość pokoi: <strong><?php the_field('rooms'); ?></strong>  <?php } ?>
													<?php if (get_field('floor')) { ?>Piętro: <strong><?php the_field('floor'); ?></strong>  <?php } ?>
													<?php if (get_field('show_balcony') and get_field('balcony')) { ?>Balkon: <strong><?php the_field('balcony'); ?> m<sup>2</sup></strong>  <?php } ?>
													<?php if (get_field('show_terrace') and get_field('terrace')) { ?>Taras: <strong><?php the_field('terrace'); ?> m<sup>2</sup></strong>  <?php } ?>
												</p>
											</div>
											<div class="col-sm-7 display-flex-middle">
												<?php $price_all = get_field('price_all');
												if (get_field('show_price') and $price_all) {
													$price = number_format( $price_all, 0, ',', ' '); ?>
													<p class="price"><span class="visible-xs-inline-block visible-sm-inline-block">Cena:  </span><?php echo $price; ?> zł</p>
												<?php } else { ?>
													<?php if (get_field('status') != 'sold') { ?><a href="" class="btn btn-default">Zapytaj o cenę</a><?php } ?>
												<?php } ?>
											</div>
										</div>
									</div>
									<div class="col-sm-3 text-right">
										<?php $model_3d = get_field('model_3d');
										if ($model_3d) { ?>
											<img src="<?php echo $model_3d['sizes']['medium']; ?>">
										<?php } ?>
									</div>
								</div>
							</div>
						<?php } ?>
					</div>
				<?php }
			wp_reset_query();
			} ?>
			
		</div>
	<?php } ?>

	<?php get_template_part( 'elements/parts/part', 'people' ); ?>

</div>

<?php if (get_field('show_popup')) {
	$popup_image = get_field('popup_image'); ?>
	<div class="modal modal-apartment fade" id="popupModal" tabindex="-1" role="dialog" aria-labelledby="popupModalLabel">
		<div class="modal-dialog<?php if (get_field('popup_size') == 'big') echo ' modal-lg'; ?>" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<?php if (get_field('popup_title')) { ?>
						<h4 class="modal-title" id="popupModalLabel"><?php the_field('popup_title'); ?></h4>
					<?php } ?>
				</div>
				<div class="modal-body row">
					<?php if ($popup_image) { ?>
						<div class="col-sm-<?php if (get_field('popup_text')) echo '6'; else echo '24'; ?> popup-image">
							<img src="<?php echo $popup_image['sizes']['large']; ?>" alt="<?php echo $popup_image['alt']; ?>">
						</div>
					<?php } ?>					
					<?php if (get_field('popup_text')) { ?>
						<div class="col-sm-<?php if ($popup_image) echo '18'; else echo '24'; ?> popup-text">						
							<?php the_field('popup_text'); ?>
						</div>
					<?php } ?>
				</div>
			</div>
		</div>
	</div>
<?php } ?>

<?php get_footer(); ?>
